
;; This program changes the Zilog 8536 counter/timer so that there is a interrupt
;; on every scanline. The Zilog 8536 counter/timer chip is found in the KC Compact only.
;;
;; This program is designed for KC Compact ONLY and will not run on the CPC
;; or CPC+.
;;
;; (c) Kevin Thacker, 2002.
;;
;; This source is released under the GNU Public License V2.

org &8000

;; disable interrupts
di

;; interrupt mode 1
im 1

;; Z8536 control port
ld b,&ee

;; reset Z8536 access state
;; after this, the Z8536 will be waiting for a register index
;; to be written.
in a,(c)

;; set counter/timer 3 time constant
;;
;; The timer appears to count HSYNC transitions. Therefore, for a single scanline
;; two transitions are required (low-high, and high-low).

;; set counter/timer 3 time constant to &0002

;; counter/timer 3 time constant msb register
ld a,&1a
out (c),a

;; set register to 0
xor a
out (c),a

;; counter/timer 3 time constant lsb register
ld a,&1b
out (c),a

;; set register to 2
ld a,2
out (c),a

;; install a interrupt handler for interrupt mode 1
ld a,&c3
ld hl,interrupt
ld (&0038),a
ld (&0039),hl

;; reset colour
xor a
ld (colour),a

;; enable interrupts
ei

;; infinite loop; interrupts will be triggered
.loop
jp loop

;; interrupt handler
.interrupt
;; disable interrupts
di
;; push registers that we change
push bc
push af

;; get hardware colour index
ld a,(colour)
;; increment
inc a
;; ensure it stays in range 0-31
and &1f
;; and store
ld (colour),a

or &40

;; select pen 0
ld bc,&7f00
out (c),c

;; set ink for pen 0
out (c),a

;; restore registers that we changed
pop af
pop bc
;; enable interrupts
ei
ret

;; stores current hardware colour index (0-31)
.colour defb 0


